# delimit ;  
set more 1 ;  
capture log close;
*global waves=8;
drop _all;
program drop _all;

cd C:\Dropbox\hrs\wealthcouples\;
*cd C:\Users\Eric\Dropbox\hrs\wealthcouples\;

*log using E:\Dropbox\hrs\wealthcouples\wlthmat.log, replace ; 
*log using c:\research\hrs\wealthcouples\wlthmat.log, replace ; 
log using wlthmat.log, replace ;
/*
use c:\research\hrs\wealth\medresid;
keep HHID *adj wave;
*rename medcost_adj medcadj; 
sort HHID wave;
save c:\research\hrs\wealth\medresid, replace;
*/


*use E:\Dropbox\hrs\wealthcouples\dataprep2_4states;
*use c:\research\hrs\wealthcouples\dataprep2_4states;
use dataprep2_4states;

*use the correct value of medcost including medicaid part b and insurance premia. NO LONGER BOTTOM CODE HERE-IN DATAPREP2;

* initial sample is from the non-institutionalized population -- were not asked about nursing home stays;
* not relevant given that we now start with wave 3;
/*
replace mannursing=0 if wave==2;
replace womannursing=0 if wave==2;
*/
/*
sort HHID wave;
replace assets=0 if hhdead==1 & hhdead[_n-1]~=1 & HHID==HHID[_n-1] & assets==.;

sort hhdead;

by hhdead: sum hhdead assets cohort wave;

*drop if cohort==.|wave==.; * should not do anything;

* now get rid of wives ;
*sort HHID realyear male;
*drop if HHID==HHID[_n+1] & realyear==realyear[_n+1];
sort HHID wave;


merge HHID wave using c:\research\hrs\wealth\medresid;
replace medcadj=medcost if medcadj==. & medcost~=.; * 3 cases --> missing health status, which is used to create medcadj;


* this gets 
sort HHID wave;
gen manmiss=0;
replace manmiss=1 if manmarstat==0 & manmarstat[_n-1]~=0 & HHID==HHID[_n-1];
replace manmiss=1 if manmarstat==0 & manmarstat[_n+1]~=0 & HHID==HHID[_n+1];
replace manmiss=1 if manmarstat==0 & (lmanmarstat~=0 & lmanmarstat~=.);

gen womanmiss=0;


replace womanmiss=1 if womanmarstat==0 & womanmarstat[_n-1]~=0 & HHID==HHID[_n-1];
replace womanmiss=1 if womanmarstat==0 & womanmarstat[_n+1]~=0 & HHID==HHID[_n+1];
replace womanmiss=1 if womanmarstat==0 & (lwomanmarstat~=0 & lwomanmarstat~=.);
 



gen manhere=0;
replace manhere=1 if (manmarstat>0 & manmarstat<9);
gen womanhere=0;
replace womanhere=1 if (womanmarstat>0 & womanmarstat<9);

tab mandead womandead;
tab manhere womanhere; 

* generate mstat;
gen mstat=.;
replace mstat=0 if (manhere==0 & womanhere==0);
replace mstat=1 if (manhere==1 & womanhere==0);
replace mstat=2 if (manhere==0 & womanhere==1);
replace mstat=3 if (manhere==1 & womanhere==1);
replace mstat=. if (manmiss==1|womanmiss==1);



/*
sort HHID wave;
gen chk=0;
replace chk=1 if (mstat==. & mstat[_n-1]==mstat[_n+1]) & (HHID==HHID[_n-1] & HHID==HHID[_n+1]);
replace chk=1 if chk[_n-1] == 1 & HHID==HHID[_n-1];
gen omwave=1-wave;
sort HHID omwave;
replace chk=1 if chk[_n-1] == 1 & HHID==HHID[_n-1];
keep if chk==1;
sort HHID wave;
order HHID wave chk mstat *woman* ;
browse;
exit;
*/


*sort HHID wave;
replace mstat=mstat[_n-1] if (mstat==. & mstat[_n-1]==mstat[_n+1]) & (HHID==HHID[_n-1] & HHID==HHID[_n+1]);

sort wave;
by wave: tab mstat;


gen missing=0;
replace missing=1 if mstat==.;


tab bothdead mstat;
drop bothdead;
gen bothdead=0;
replace bothdead=1 if mstat==0;
*/

save wlth, replace;
*save E:\Dropbox\hrs\wealthcouples\wlth, replace;
*save c:\research\hrs\wealthcouples\wlth, replace;

*Infer HHstatus for temporary atrtition with lagged status and date of death;
*realyear variable;
replace realyear=realyear+ 1900.3;
tab realyear;
gen hhstatusmiss=(hhstatus==.);
gen hhstatus_open=hhstatus if hhstatusmiss==0 & hhstatusmiss[_n+1]==1; *if missing tomorrow record today's status;
gen hhstatus_close=hhstatus if hhstatusmiss[_n-1]==1 & hhstatusmiss==0; *if missing yesterday record today's status;

*drop cycling in and out attriters;
egen temp_count=count(hhstatus_open), by(HHID); *count nonmissing observations;
drop if temp_count!=. &temp_count>1; *drop multiple absent spells;

*copy open and close across all waves- max(all missing) returns missing otherwise largest nonmissing values;
egen temp_open=max(hhstatus_open), by(HHID); *pick up the hhstatus_open in all waves;
egen temp_close=max(hhstatus_close), by(HHID); *pick up the hhstatus_close in all waves;
replace hhstatus_open=temp_open;
replace hhstatus_close=temp_close;
drop temp_open temp_close temp_count;

*return as same hhstatus;
replace hhstatus=hhstatus_open if (hhstatus_close==hhstatus_open) & hhstatusmiss==1; *If same hhstatus fill;

*if single woman after return;
replace hhstatus=hhstatus_open if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==1 & deathyrman>realyear; 
replace hhstatus=hhstatus_close if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==1 & deathyrman<=realyear; 
*if single man after return;
replace hhstatus=hhstatus_open if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==2 & deathyrwoman>realyear; 
replace hhstatus=hhstatus_close if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==2 & deathyrwoman<=realyear; 

*if return as dead;
*start as single woman;
replace hhstatus=hhstatus_open if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==0 &hhstatus_open==1 & deathyrwoman>realyear; 
replace hhstatus=hhstatus_close if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==0 &hhstatus_open==1 & deathyrwoman<=realyear; 
*start as single man;
replace hhstatus=hhstatus_open if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==0 &hhstatus_open==2 & deathyrman>realyear; 
replace hhstatus=hhstatus_close if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==0 &hhstatus_open==2 & deathyrman<=realyear; 
*start as couple;
replace hhstatus=hhstatus_open if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==0 &hhstatus_open==3 & deathyrman>realyear & deathyrwoman>realyear; *both alive;
replace hhstatus=hhstatus_close if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==0 &hhstatus_open==3 & deathyrman<=realyear & deathyrwoman<=realyear; *both dead;
replace hhstatus=2 if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==0 &hhstatus_open==3 & deathyrman>realyear & deathyrwoman<=realyear;  *man still alive;
replace hhstatus=1 if (hhstatus_close!=hhstatus_open) & hhstatusmiss==1 & hhstatus_close==0 &hhstatus_open==3 & deathyrman<=realyear & deathyrwoman>realyear; *woman still alive;

drop hhstatus_open hhstatus_close hhstatusmiss;

sort HHID wave;
replace pi_perc=pi_perc[_n-1] if HHID==HHID[_n-1];
replace pi_perc_weighted=pi_perc_weighted[_n-1] if HHID==HHID[_n-1];
*gen pi_perc_weighted=pi_perc;


*sum adist*;
*exit;
keep HHID wgthh*  /*agej**/ pi_perc* hhstatus assets* homeeq SSDIY hhmedcost_b /*medcadj**/ hhmedicaid hhmedicaid_pay mannursing womannursing hhdead manheal womanheal hhage wave firstwave;
gen pi_perc_meas2 = pi_perc_weighted;  * later I will program in pi_perc (weighted) ;

*reshape wide assets homeeq SSDIY hhstatus hhmedcost /*medcadj*/ mannursing womannursing hhmedicaid manheal womanheal hhage hhdead /*agej*/ pi_perc pi_perc_meas2 wgthh, i(HHID) j(wave);
reshape wide assets homeeq SSDIY hhstatus hhmedcost_b /*medcadj*/ mannursing womannursing hhmedicaid hhmedicaid_pay  manheal womanheal hhage hhdead /*agej*/ wgthh, i(HHID) j(wave);

*gen weight=wgthh2 if firstwave==2; * will work if wave>=firstwave;
gen weight=wgthh3 if firstwave==3; * will work if wave>=firstwave;
replace weight=wgthh4 if firstwave==4; * will work if wave>=firstwave;
*replace weight=wgthh3 if weight==.;
replace weight=wgthh4 if weight==.;
replace weight=wgthh5 if weight==.;
replace weight=wgthh6 if weight==.;
replace weight=wgthh7 if weight==.;
replace weight=wgthh8 if weight==.;
replace weight=wgthh9 if weight==.;
replace weight=wgthh10 if weight==.;
replace weight=wgthh11 if weight==.;
replace weight=wgthh12 if weight==.;

drop wgt*;

/*
* generate agej--age in wave 2 (1993);
gen agej=agej2;
replace agej=agej2-2 if agej==.;
replace agej=agej4-5 if agej==.;
replace agej=agej5-7 if agej==.;
replace agej=agej6-9 if agej==.;
*/
* make variables equal to zero if they are missing, but flag them;
program define genmiss1;
        version 3.1;
local i = firstwave ;
local waves = 12;
    while `i' <=`waves' { ;	
	* missing marital status;
	gen hhstatusmiss`i'=1;
	replace hhstatusmiss`i'=0 if hhstatus`i'~=.;
	replace hhstatus`i'=0 if hhstatusmiss`i'==1; //set to zero?

	* missing assets;
	gen assetsmiss`i'=1;
	replace assetsmiss`i'=0 if assets`i'~=.;
	replace assets`i'=0 if assetsmiss`i'==1;
 
	* missing homeeq value;
	gen homeeqmiss`i'=1;
	replace homeeqmiss`i'=0 if homeeq`i'~=.;
	replace homeeq`i'=0 if homeeqmiss`i'==1;
	
	* missing SSDIY value;
	gen SSDIYmiss`i'=1;
	replace SSDIYmiss`i'=0 if SSDIY`i'~=.;
	replace SSDIY`i'=0 if SSDIYmiss`i'==1;

	* missing medical costs;
	gen hhmedcostmiss`i'=1;
	replace hhmedcostmiss`i'=0 if hhmedcost_b`i'~=.;
	replace hhmedcost_b`i'=0 if hhmedcostmiss`i'==1;
/*
	* missing adjusted medical costs;
	gen medcadjmiss`i'=1;
	replace medcadjmiss`i'=0 if medcadj`i'~=.;
	replace medcadj`i'=0 if medcadjmiss`i'==1;
*/
	* missing men nursing home nights;
	gen mannursingmiss`i'=1;
	replace mannursingmiss`i'=0 if mannursing`i'~=.;
	replace mannursing`i'=0 if mannursingmiss`i'==1;
	
	* missing women nursing home nights;
	gen womannursingmiss`i'=1;
	replace womannursingmiss`i'=0 if womannursing`i'~=.;
	replace womannursing`i'=0 if womannursingmiss`i'==1;

	* missing man medical health status;
	gen manhealmiss`i'=1;
	replace manhealmiss`i'=0 if manheal`i'~=.;
	replace manheal`i'=0 if manhealmiss`i'==1;

	* missing woman medical health status;
	gen womanhealmiss`i'=1;
	replace womanhealmiss`i'=0 if womanheal`i'~=.;
	replace womanheal`i'=0 if womanhealmiss`i'==1;
	
	* missing medical health status;
	gen hhagemiss`i'=1;
	replace hhagemiss`i'=0 if hhage`i'~=.;
	replace hhage`i'=0 if hhagemiss`i'==1;

	* missing medicaid;
	gen hhmedicaidmiss`i'=1;
	replace hhmedicaidmiss`i'=0 if hhmedicaid`i'~=.;
	replace hhmedicaid`i'=0 if hhmedicaidmiss`i'==1;
	
	* missing medicaid payments;
	gen hhmedicaid_paymiss`i'=1;
	replace hhmedicaid_paymiss`i'=0 if hhmedicaid_pay`i'~=.;
	replace hhmedicaid_pay`i'=0 if hhmedicaid_paymiss`i'==1;

	local i = `i'+1 } ;
end;
set trace off ;
genmiss1;


*exit;

forval i=3/12 {;
recode hhstatus`i' (9=0);
};
drop if hhstatus3==0;                      * keep only those who we observe in wave 3 (1995);
*drop if (age3<72|age3>91); 				     
keep HHID weight /*agej*/ pi_perc pi_perc_meas2 hhstatus* assets* homeeq* SSDIY* hhmedcost* /*medcadj**/ mannursing* womannursing* hhmedicaid* manheal* womanheal* hhdead* hhage*;



* make variables equal to zero if they are missing, but flag them;
program define genchk1;
        version 3.1;
local i = 3 ;
local waves = 12;
    while `i' <=`waves' { ;	
gen avmanheal`i'=(1-manheal`i');
replace avmanheal`i'= . if (manhealmiss`i'==1 | hhstatus`i'==0);
gen avwomanheal`i'=(1-womanheal`i');
replace avwomanheal`i'= . if (womanhealmiss`i'==1 | hhstatus`i'==0);
	local i = `i'+1 } ;
end;
set trace off ;
genchk1;



* make variables equal to zero if they are missing, but flag them;
program define genmean1;
        version 3.1;
local i = 3 ;
local waves = 12;
    while `i' <=`waves' { ;	
tab hhstatus`i';
sum hhdead`i'  avmanheal`i' avwomanheal`i';
	local i = `i'+1 } ;
end;
set trace off ;
genmean1;

sort hhstatus3;
by hhstatus3: sum hhstatus* hhdead* av*;



drop hhdead* av*;

*drop medcadj* ;




*order HHID weight  agej pi_perc mstat* assets* homeeq* medcost* medcadj* nursing* medicaid* heal* age* ;
order HHID weight /*agej*/ pi_perc pi_perc_meas2 hhstatus* assets* homeeq* SSDIY* hhmedcost* 
mannursing* mannursingmiss* womannursing* womannursingmiss* hhmedicaid? hhmedicaid?? hhmedicaidmiss? hhmedicaidmiss??  hhmedicaid_pay? hhmedicaid_pay?? hhmedicaid_paymiss? hhmedicaid_paymiss?? manheal* womanheal* hhage* ;


sum ;

outsheet using wlthmat,nonames replace;

export excel using wlthmat, sheetreplace firstrow(variables);

*outsheet using E:\Dropbox\hrs\wealthcouples\wlthmat,nonames replace;
*outsheet using c:\research\hrs\wealthcouples\wlthmat,nonames replace;
save wlthmat, replace;
*save E:\Dropbox\hrs\wealthcouples\wlthmat, replace;
*save c:\research\hrs\wealthcouples\wlthmat, replace;
program drop _all;
log close ;




